param (
    [string]$PrinterName
)

# Registry-Pfad zusammenbauen
$regPath = "HKLM:\SYSTEM\CurrentControlSet\Control\Print\Printers\$PrinterName\DsDriver"

# Prüfe, ob der Registry-Pfad existiert
if (Test-Path $regPath) {
    #Write-Host "Registry-Pfad gefunden: $regPath"
    
    # Prüfe, ob printCollate existiert
    $valueExists = Get-ItemProperty -Path $regPath -Name printCollate -ErrorAction SilentlyContinue

    if ($valueExists) {
        Write-Host "Loesche alten Wert von Farbruck..."
        Remove-ItemProperty -Path $regPath -Name printCollate -ErrorAction SilentlyContinue
    }

    # Setze printCollate auf 00 (Schwarz-Weiß)
    Write-Host "Setze Graustufendruck auf ein..."
    New-ItemProperty -Path $regPath -Name printCollate -PropertyType Binary -Value ([byte[]](0x00)) -Force
    Write-Host "Fertig!"
} else {
    Write-Host "Fehler: Registry-Pfad nicht gefunden! Stelle sicher, dass der Drucker installiert ist."
}
